### RXPDO参数说明

| **输入参数** | **数据类型** | **含义** |
|---|---|---|
| CHx |
| Counter value | UDINT | 当前计数值，最高位为符号位（实际为有符号数据）。 |
| C Latch value | UDINT | 根据配置，在C相锁存的当前计数值。 |
| CHx Status |
| input A | BOOL | A相输入 |
| input B | BOOL | B相输入 |
| input C | BOOL | C相输入 |
| Counter overflow | BOOL | 1：当前计数值上溢出；0：计数值上溢出后，继续向上计数值超过5000. |
| Counter underflow | BOOL | 1：当前计数值下溢出；0：计数值下溢出后，继续向下计数值超过5000. |
| Set counter done | BOOL | 1：有效设置计数器当前计数值；0：Set counter为0； |
| Latch C valid | BOOL | 1：C相输入锁存标志位；0：未进行锁存； |
| 其他 |
| Latch1 | BOOL | 1：Latch1通道有信号输入；0：Latch1通道无信号输入； |
| Latch1 valid | BOOL | 1：Latch1信号锁存成功标志位；0：未进行锁存； |
| Latch1 value | UDINT | 根据配置，Latch1信号锁存的当前计数值。 |
| Latch2 | BOOL | 1：Latch2通道有信号输入；0：Latch2通道无信号输入； |
| Latch2 valid | BOOL | 1：Latch2信号锁存成功标志位；0：未进行锁存； |
| Latch2 value | UDINT | 根据配置，Latch2信号锁存的当前计数值。 |
| Latch3 | BOOL | 1：Latch3通道有信号输入；0：Latch3通道无信号输入； |
| Latch3 valid | BOOL | 1：Latch3信号锁存成功标志位；0：未进行锁存； |
| Latch3 value | UDINT | 根据配置，Latch3信号锁存的当前计数值。 |
| Latch4 | BOOL | 1：Latch4通道有信号输入；0：Latch4通道无信号输入； |
| Latch4 valid | BOOL | 1：Latch4信号锁存成功标志位；0：未进行锁存； |
| Latch4 value | UDINT | 根据配置，Latch4信号锁存的当前计数值。 |

---

### TXPDO参数说明

| **参数** | **数据类型** | **含义** |
|---|---|---|
| CHx |
| Set counter value | UDINT | 当前计数值设置值 |
| ConfigData | BYTE | Bit0~Bit7设置模块工作方式配置 |
| Set counter | BIT | 上升沿将Set counter value设置到当前计数值Counter value |
| Enable latch C | BIT | 1：在C相输入上升沿锁存Counter value到Latch value注意只锁存一次，若需要再次启动锁存，需要置0该参数后重新置1（避免因为干扰导致无效的异常锁存）。 |
| Clear cnt val | BIT | 清除通道计数值 |
| Clear flow flag | BIT | 清除通道上溢出和下溢出标志 |
| Gate threshold0 | UDINT | 门控比较值0 |
| Gate threshold1 | UDINT | 门控比较值1 |
| Latchx Ctrl |
| ConfigData | BYTE | 锁存方式配置 |
| Enable latch extern on positive edge | BIT | 1：在Latch上升沿锁存Counter value到Latch value注意只锁存一次，若需要再次启动锁存，需要置0该参数后重新置1（避免因为干扰导致无效的异常锁存）。 |
| Enable latch extern on negative edge | BIT | 1：在Latch下降沿锁存Counter value到Latch value注意只锁存一次，若需要再次启动锁存，需要置0该参数后重新置1（避免因为干扰导致无效的异常锁存）。 |

---

### 参数配置说明（通道）

SRE5012

| **工作模式** |
|---|
| 位 | Bit1 | Bit0 |
| 工作模式 |  |
| AB相正交4倍频计数 | 0 | 0 |
| AB相正交单倍频计数 | 0 | 1 |
| 脉冲+方向计数  （A：脉冲 B：方向，B高电平减计数，低电平加计数） | 1 | 0 |
| **工作信号** |
| 位 | Bit3 | Bit2 |
| 工作模式 |  |
| 5V | 0 | 0 |
| 24V | 0 | 1 |
| **门控输出配置** |
| 位 | Bit6 | Bit5 | Bit4 |
| 门控模式 |  |
| 门控输出模式1 | 0 | 0 | 1 |
| 门控输出模式2 | 0 | 1 | 1 |
| 门控输出模式3 | 1 | 0 | 1 |
| 门控输出模式4 | 1 | 1 | 1 |
| **滤波配置** |
| 位 | Bit7 |
| 滤波配置 |  |
| 关闭滤波 | 0 |
| 开启滤波 | 1 |